const LIMIT = 30
const app = Vue.createApp({
  setup() {
    document.body.removeAttribute('hidden')
  },
  data () {
    return {
      comments: []
    }
  },
  methods: {
    getClassName(comment) {
      if (comment.commentIndex % 2 === 0) {
        return 'comment even'
      }
      return 'comment odd'
    },
    getStyle(comment) {
      return OneSDK.getCommentStyle(comment)
    }
  },
  mounted () {
    const WAIT_DURATION = OneSDK.getStyleVariable('--lcv-wait-duration', 100, parseInt)
    const INTERVAL = OneSDK.getStyleVariable('--lcv-enter-duration', 160, parseInt) + WAIT_DURATION
    const LIFE_TIME = OneSDK.getStyleVariable('--lcv-lifetime', 5000, parseInt) + WAIT_DURATION
    
    commentIndex = 0
    OneSDK.setup({
      mode: 'diff',
      commentLimit: LIMIT,
      disabledDelay: true
    })

    OneSDK.subscribe({
      action: 'comments',
      callback: (comments) => {
        if (comments.length !== 0) {
          tensei.recieve(comments)
        }
      }
    })
    OneSDK.connect()
  },
})
OneSDK.ready().then(() => {
  app.mount("#container");
})




// 転生
var tensei = {

	sound: null,
	timers: {},
	randomMargin: 10,
	historyX: [],
	cheerTiers: [0,100,1000,5000,10000,25000,50000,75000,100000],

	// 初期設定
	init: function() {

		const textSize = characterScale*5*(fontSize*.01);
		document.documentElement.style.setProperty('font-size', textSize+'px');
		document.documentElement.style.setProperty('--max-cols', maxCols+'rem');
		document.documentElement.style.setProperty('--max-lines', maxLines);
		document.documentElement.style.setProperty('--dot-size', characterScale+'px');
		document.documentElement.style.setProperty('--half-size', (characterScale * 0.5)+'px');
		document.documentElement.style.setProperty('--minus-half-size', (characterScale * -0.5)+'px');
		if (hideName == 1) document.body.classList.add('hide-name');
		tensei.randomMargin = (areaRight - areaLeft) * .1;
		
		// キャラロード
		const cache = document.createElement('div');
		cache.id = 'cache';
		for (let i = 0; i < 256; i++) {
			let hex = i.toString(16).padStart(2, '0');
			const image = document.createElement('img');
			image.src = `./assets/character/${hex}.png`;
			cache.append(image);
		}
		document.body.append(cache);

		// サウンドロード
		tensei.sound = new Audio('./assets/sound/pop.mp3');
		tensei.sound.volume = 0;
		tensei.sound.play();
	},

	// コメント検知
	recieve: function(comments) {
		console.log(comments);
		comments.forEach(function(comment, index) {
			setTimeout(function() {
				tensei.pop(comment.data);
			}, index*100);
		});
	},

	// キャラ出現
	pop: function(data) {

		// スパチャに関する出現フラグのチェック
		if (appearsType == 1 && data.isMember == false
			|| appearsType == 1 && data.subscriber == "0"
			|| appearsType == 2 && !data.price) {
			return;
		}

		const hash = tensei.hash(data.displayName);
		const hex = hash.slice(0, 2);
		let listener;

		// キャラセット
		if (document.getElementById(`listener-${hash}`)) {
			listener = document.getElementById(`listener-${hash}`);
			listener.className = '';
			document.getElementById('listener').append(listener);
			// キャラの位置被り対策
			tensei.historyX.push(parseInt(listener.dataset.x));
			if (tensei.historyX.length > 3) {
				tensei.historyX.shift();
			}
		}
		else {
			listener = document.createElement('li');
			listener.id = `listener-${hash}`;
			listener.classList.add('first');
			const width = imageData[hex].width*characterScale;
			const x = tensei.randomX(areaLeft,areaRight);
			listener.dataset.x = x;
			listener.style.left = width*.5 + (window.innerWidth-width)*(x*.01) + 'px';
			const container = tensei.createElement('div', 'container');
			const comment = tensei.createElement('div', 'comment');
			const name = tensei.createElement('em', 'name', data.displayName);
			const badge = tensei.createElement('b', 'badge')
			if (data.badges) {
				data.badges.forEach(item => {
					const b = document.createElement('img');
					b.src = item.url;
					badge.classList.add('exclusive');
					badge.append(b);
				});
			}
			name.prepend(badge);
			const price = tensei.createElement('i', 'price');
			const priceUnit = tensei.createElement('small', 'price-unit');
			const priceNum = tensei.createElement('var', 'price-num');
			tensei.appendAll(price, [priceUnit, priceNum]);
			const message = tensei.createElement('p', 'message');
			const messageContent = tensei.createElement('span', 'content');
			message.append(messageContent);
			tensei.appendAll(container, [name, price, message]);
			comment.append(container);
			const image = tensei.createElement('img', 'character');
			image.src = `./assets/character/${hex}.png`;
			image.style.width = `${width}px`;
			image.style.height = `${imageData[hex].height*characterScale}px`;
			tensei.appendAll(listener, [comment, image]);
			document.getElementById('listener').append(listener);
		}

		// スパチャ
		if (data.tier) {
			listener.classList.add('tier', `tier${data.tier}`);
			listener.querySelector('.price-unit').innerText = data.unit;
			listener.querySelector('.price-num').innerText = data.price;
		}
		// TwitchのCheer
		else if (data.bits) {
			listener.classList.add('cheer', `tier${tensei.getCheerTier(data.price)}`);
			listener.querySelector('.price-unit').innerText = '';
			listener.querySelector('.price-num').innerText = data.price;
		}
		else {
			listener.querySelector('.price-unit').innerText = '';
			listener.querySelector('.price-num').innerText = '';
		}

		// メンバーシップ
		if (data.isMember || data.subscriber && data.subscriber != "0") {
			listener.classList.add('member');
		}
		else {
			listener.classList.remove('member');
		}

		// ギフト
		if (data.giftType && data.giftType != 'superchat') {
			listener.classList.add('gift');
		}
		else {
			listener.classList.remove('gift');
		}

		listener.querySelector('.message .content').innerHTML = data.membership ? data.membership.sub : data.comment;
		listener.classList.add('jump');

		tensei.sound.pause();
		tensei.sound.currentTime = 0;
		tensei.sound.volume = 1;
		tensei.sound.play();

		if (tensei.timers[listener.id]) clearTimeout(tensei.timers[listener.id]);
		tensei.timers[listener.id] = setTimeout(() => {
			listener.classList.add('fall');
			tensei.timers[listener.id] = setTimeout(() => {
				listener.classList.add('back');
				tensei.timers[listener.id] = setTimeout(() => {
					if (tensei.timers[listener.id]) clearTimeout(tensei.timers[listener.id]);
					listener.remove();
				}, 800);
			}, characterLife*1000);
		}, commentLife*1000);
	},

	// 入力文字列かた2桁の16進数生成
	hash: function(str) {
		return XXH.h32(str, 0xABCD).toString(16);
	},

	// ランダム数値生成
	randomX: function(min, max) {
		min = Math.ceil(min);
		max = Math.floor(max);

		if (tensei.historyX.length == 0) {
			const value = Math.floor(Math.random() * (max - min + 1)) + min;
			const rounded = Math.round(value);
			tensei.historyX.push(rounded);
			return rounded;
		}
		else {
			// 過去3キャラとは被りにくく
			while (true) {
				const randomValue = Math.floor(Math.random() * (max - min + 1)) + min;
				if (tensei.historyX.every(history => Math.abs(randomValue - history) >= tensei.randomMargin)) {
					const value = Math.round(randomValue);
					tensei.historyX.push(value);
					if (tensei.historyX.length > 3) {
						tensei.historyX.shift();
					}
					return value;
				}
			}
		}
	},

	// TwitchのCheerのTier算出
	getCheerTier: function(price) {
		for (let i = tensei.cheerTiers.length - 1; i >= 0; i--) {
			if (price >= tensei.cheerTiers[i]) {
				return i + 1;
			}
		}
		return 0;
	},

	// エレメント作成
	createElement: function(tagName, className, content) {
		const element = document.createElement(tagName);
		if (className) element.classList.add(className);
		if (content) element.append(content);
		return element;
	},

	// 一括append
	appendAll: function(target, array) {
		let fragment = new DocumentFragment();
		array.forEach(item => {
			fragment.append(item);
		});
		target.append(fragment);
	},

	// 文字列ランダムシャッフル（サンプル用）
	confusion(str) {
		let arr = str.split('');
		for (let i = arr.length - 1; i > 0; i--) {
			let j = Math.floor(Math.random() * (i + 1));
			[arr[i], arr[j]] = [arr[j], arr[i]];
		}
		return arr.join('');
	}

}

document.addEventListener('DOMContentLoaded', tensei.init);