const LOCALSTORAGE_KEY = {
	CONFIG: 'vtfx'
}

var controller = {

	obs: null,

	// 音量設定初期値
	config: {
		slot1: { volume: 1.0 },
		slot2: { volume: 1.0 },
		slot3: { volume: 1.0 },
		slot4: { volume: 1.0 },
		slot5: { volume: 1.0 },
		slot6: { volume: 1.0 }
	},

	// 起動
	init: function() {
		// 設定ロード
		const savedConfig = localStorage.getItem(LOCALSTORAGE_KEY.CONFIG);
		if (savedConfig) {
			controller.config = JSON.parse(savedConfig);
		}

		// OBSと接続
		controller.connect();

		// サムネイルロード
		document.querySelectorAll('#main-interface .thumbnail').forEach(thumbnail => {
			thumbnail.addEventListener('load', controller.thumbnailLoaded);
			thumbnail.src = thumbnail.dataset.src;
		});

		// 設定類
		const slot = document.querySelectorAll('#main-panel .slot').length;
		for (let i=1; i<=slot; i++) {
			const setting = document.getElementById(`settings${i}`);
			const volume = controller.config[`slot${i}`].volume;
			const input = setting.querySelector('input');
			setting.querySelector('.volume').innerText = volume*100;
			input.value = volume;
			input.addEventListener('input', controller.updateVolumeDisplay);
			input.addEventListener('change', controller.updateVolume);
		};
	},

	// UI起動
	boot: function() {
		setTimeout(function() {
			document.body.classList.add('loaded');
		}, 600);
	},

	// サムネイルロード成功時の処理
	thumbnailLoaded: function(event) {
		const target = event.target;
		const button = target.closest('button');
		button.classList.remove('empty');
		button.classList.add('ready');
	},

	// OBSのWebSocketに接続
	connect: function(que) {
		controller.obs = new OBSWebSocket();
		controller.obs.connect(`ws://localhost:${port}`, password).then(() => {
			console.log( '› Connected to OBS' );
			if (que != null) {
				controller.send(que);
			}
		})
		.catch(error => {
			console.error( '› ' + error.toString());
		});
	},

	// 動画再生ソースへのリクエスト
	send: async function(i) {

		// 接続が切れていたら再接続してリクエスト
		if (controller.obs.socket == null) {
			controller.connect(i);
			return;
		}

		try {
			const volume = (i == 0) ? 0 : controller.config[`slot${i}`].volume;
			await controller.obs.call('BroadcastCustomEvent', {
				'eventData': { 'realm': 'V+FX', 'type': 'action', 'action': 'play', 'slot': i, 'volume': volume }
			});
		}
		catch (error) {
			console.error('Error changing source URL', error);
		}
	},

	// 音量設定表示変更
	updateVolumeDisplay: function(event) {
		const target = event.target;
		const setting = target.closest('.slot');
		setting.querySelector('.volume').innerText = target.value*100;
		controller.config[target.dataset.target].volume = target.value;
	},

	// 音量設定保存
	updateVolume: function() {
		localStorage.setItem(LOCALSTORAGE_KEY.CONFIG, JSON.stringify(controller.config));
	},

	// 設定画面を開く
	openSettings: function() {
		document.body.classList.add('settings');
	},

	// 設定画面を閉じる
	closeSettings: function() {
		document.body.classList.remove('settings');
	}

}

// 発火
window.addEventListener('DOMContentLoaded', controller.init);
window.addEventListener('load', controller.boot);