var receiver = {

	obs: null,
	soundManager: [],
	previous: 0,
	checker: null,

	size: {
		width: 0,
		height: 0,
		aspect: 1
	},

	// 起動
	init: function() {

		receiver.size.width = window.innerWidth;
		receiver.size.height = window.innerHeight;
		receiver.size.aspect = window.innerWidth / window.innerHeight;
		
		// OBSと接続
		receiver.connect();

		// 動画お試しロード
		document.querySelectorAll('#videos .video').forEach(video => {
			video.addEventListener('loadeddata', receiver.videoLoaded);
			video.addEventListener('ended', receiver.videoEnded);
			video.load();
		});

		setTimeout(receiver.loaded, 200);
	},

	// 動画のロード成功時の処理
	videoLoaded: function(event) {
		const target = event.target;
		target.classList.remove('empty');
	},

	// 動画の再生終了
	videoEnded: function(event) {
		event.target.classList.add('ended');
		event.target.classList.remove('play');
	},

	// サムネイルロード成功時の処理
	thumbnailLoaded: function() {
		const target = window.event.target;
		target.classList.remove('empty');
	},

	// OBSのWebSocketに接続
	connect: function() {
		receiver.obs = new OBSWebSocket();
		receiver.obs.connect(`ws://localhost:${port}`, password).then(() => {
			receiver.obs.off('CustomEvent', receiver.receive);
			receiver.obs.on('CustomEvent', receiver.receive);
			if (receiver.checker == null) {
				receiver.checker = setInterval(receiver.heartbeat, 10000);
			}
		})
		.catch(error => {
			alert(error.toString());
		});
	},

	// 接続定期チェック
	heartbeat: function() {
		// 接続が切れていたら再接続してリクエスト
		if (receiver.obs.socket == null) {
			receiver.connect();
		}
	},

	// 動画再生リクエストの受信
	receive: function(data) {
		if (!data.realm) return;
		if (data.realm != 'V+FX') return;

		if (data.type == 'action') {
			if (data.action == 'play') {
				const i = data.slot;
				receiver.action(parseInt(i), data.volume);
			}
			else if (data.action == 'startScreenShotMode') {
				receiver.startSsMode(data.areaAspect);
			}
			else if (data.action == 'endScreenShotMode') {
				receiver.endSsMode();
			}
		}
	},

	// 選択動画の再生
	action: function(i, volume) {

		// SS撮影モードの場合は抜ける
		if (document.body.classList.contains('ss')) {
			return;
		}

		// 空のスロットは抜ける
		if (i != 0 && document.getElementById('slot'+i).classList.contains('empty')) {
			return;
		}

		// 選択された動画音声がフェードアウト中なら一旦解除
		if (receiver.soundManager[i]) {
			clearInterval(receiver.soundManager[i]);
			receiver.soundManager[i] = null;
		}

		// 一つ前の動画音声をフェードアウト
		if (receiver.previous && receiver.previous != i) {
			receiver.fadeOutSound(receiver.previous);
			document.querySelector('#videos video.play')?.classList.remove('play');
		}

		// Clearの場合は以上で処理を抜ける
		if (i == 0) {
			receiver.previous = 0;
			return;
		}

		// 選択動画の再生（ローカルファイルで爆速なのでリスク回避に毎回リロード）
		const video = document.getElementById(`slot${i}`);
		video.load();
		video.classList.remove('ended');
		video.classList.add('play');
		video.currentTime = 0;
		video.volume = volume;
		video.play();
		receiver.previous = i;
	},

	// 動画音声のフェードアウト
	fadeOutSound: function(i) {
		const video = document.getElementById(`slot${i}`);
		const duration = 800;
		const interval = 50;
		const step = video.volume / (duration / interval);
		
		const fadeOut = setInterval(() => {
			if (video.volume > 0) {
				video.volume = Math.max(0, video.volume - step);
			}
			else {
				clearInterval(fadeOut);
				receiver.soundManager[i] = null;
			}
		}, interval);
		receiver.soundManager[i] = fadeOut;
	},

	// SS撮影モード
	startSsMode: function(areaAspect) {
		document.getElementById('thumbnails').style.aspectRatio = areaAspect;
		if (areaAspect <= receiver.size.aspect) {
			document.body.classList.add('fit-vertical');
			document.body.classList.remove('fit-horizontal');
		}
		else {
			document.body.classList.add('fit-horizontal');
			document.body.classList.remove('fit-vertical');
		}
		document.body.classList.add('ss');
	},
	
	// SS撮影モード終了
	endSsMode: function() {
		document.body.classList.remove('fit-vertical');
		document.body.classList.remove('fit-horizontal');
		document.body.classList.remove('ss');
	},

	// Receiverのロード完了を通知
	loaded: async function() {
		try {
			await receiver.obs.call('BroadcastCustomEvent', {
				'eventData': { 'realm': 'V+FX', 'type': 'notification', 'notification': 'receiverLoaded' }
			});
		}
		catch (error) {
			console.error('Error changing source URL', error);
		}
	}

}

// 発火
window.addEventListener('DOMContentLoaded', receiver.init);